<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'test'); // change this depending on your filename

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(

);

// get special data templates from the datastore
$specialtemplates = array(
    
);

// pre-cache templates used by all actions
$globaltemplates = array(
    'TEST',
);

// pre-cache templates used by specific actions
$actiontemplates = array(

);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

if (!can_administer('canadminstyles')){
	print_cp_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$navbits = array();
$navbits[$parent] = 'Test Page';

print_cp_header();
$terms = TABLE_PREFIX .'seoqueries_terms';
$terms_data = TABLE_PREFIX .'seoqueries_data';
$terms_stats = TABLE_PREFIX .'seoqueries_terms_stats';

//search form
if ($_REQUEST['do'] == 'search' || $_REQUEST['do'] == 'searching'){
	$key = '';
	$start = '';
	$end = '';
	if ( $_REQUEST['do'] == 'searching'){
		$vbulletin->input->clean_array_gpc('p', array(
			'start_date'	=> TYPE_STR,
			'end_date'		=> TYPE_STR,
			'keyword'		=> TYPE_STR,
		));
		$key = $vbulletin->GPC['keyword'];
		$start = $vbulletin->GPC['start_date'];
		$end = $vbulletin->GPC['end_date'];
	}
	//print_table_start();
	print_form_header('seofq_admin', 'searching');
	print_table_header("Search keywords", 2, false, '', 'center');
	
	
	print_input_row('Keyword', 'keyword', $key );
	print_description_row('Date format is: YYYY-MM-DD', 0, 2, '', 'left');
	print_input_row('Start date', 'start_date', $start );
	print_input_row('End date', 'end_date', $end );
	print_submit_row('Submit', 'Reset', 2);
	
	print_table_footer(2, '', '', 0);
}
//search script
if ($_REQUEST['do'] == 'searching'){

	$vbulletin->input->clean_array_gpc('p', array(
		'start_date'	=> TYPE_STR,
		'end_date'		=> TYPE_STR,
		'keyword'		=> TYPE_STR,
	));
	
	print_table_start();
	print_table_header("Keywords", 2, false, '', 'center');
	
	$keyword = $vbulletin->GPC['keyword'];
	$start_date = $vbulletin->GPC['start_date'];
	$end_date = $vbulletin->GPC['end_date'];
	
	$sql = "SELECT * FROM $terms WHERE term_value ='$keyword'";
	$temp = $db->query_read( $sql );
	$row = $db->fetch_array( $temp );
	if (!empty($row)){
		$sql = "SELECT * FROM ".$terms_stats." WHERE stid='".$row['stid']."'";
		
		if( preg_match( '/(\d{4})-(\d{2})-(\d{2})/', $vbulletin->GPC['start_date'], $match ) ){
			$sql .= ' AND date_clicked > \''.$match[1].'-'.$match[2].'-'.$match[3].' 00:00:00\' ';
		}
		/*
		else{
			print_stop_message('Start date invalid format.');
		}
		*/
		if( preg_match('/(\d{4})-(\d{2})-(\d{2})/', $vbulletin->GPC['end_date'], $match ) ){
			$sql .= ' AND date_clicked < \''.$match[1].'-'.$match[2].'-'.$match[3].' 00:00:00\' ';
		}
		/*
		else{
			print_stop_message('End date invalid format.');
		}
		*/
		$sql .=" ORDER BY date_clicked DESC";
		
		print_cells_row( array( 'Date', 'Position on Google' ), false, '', 3 );
		$s_terms = $db->query_read( $sql );
		while ($s_term = $db->fetch_array($s_terms)){
			print_cells_row( array( $s_term['date_clicked'], $s_term['position'] ), false, '', 3 );
		}
		
	}else{
		//matching posible search terms
		$sql = "SELECT * FROM $terms WHERE term_value LIKE '%$keyword%'";
		
		$terms = $db->query_read( $sql );
		while ($term = $db->fetch_array($terms)){
			//print_cells_row( array( $term['term_value'], '' ), false, '', 3 );
			print_description_row( $term['term_value'], 0, 2, '', 'center');
		}
	}
	print_table_footer(2, '', '', 0);
}

if ($_REQUEST['do'] == 'statistic'){
	//defines
	$titles = array( 'Search Term', 'No of Searches', 'Position in google', 'Last clicked' );
	//begin print
	
	
	//home page
	print_table_start();
	print_table_header("Home page terms statistic", 4, false, '', 'center');
	print_cells_row( $titles, 1, '', 3 );
	$q = "
		SELECT
			*
		FROM
			$terms_data sd
		LEFT JOIN
			$terms st ON sd.stid=st.stid
		WHERE
			sd.page_type='index'
		ORDER BY
			sd.founded DESC
		";
	$index_terms = $db->query_read( $q );
	while ($index_term = $db->fetch_array($index_terms)){
		//$print_terms[] = $index_term;
		$q = "
			SELECT
				position, date_clicked
			FROM
				".$terms_stats."
			WHERE
				page_type = '".$index_term['page_type']."'
				AND
				page_id = ".$index_term['page_id']."
				AND
				stid = ".$index_term['stid']."
			ORDER BY
				date_clicked DESC
			LIMIT 1
			";
		$date_temp = $db->query_read( $q );
		$date_pos = $db->fetch_array( $date_temp );
		print_cells_row(
					array(
						$index_term['term_value'],
						$index_term['founded'],
						$date_pos['position']==0?'-':$date_pos['position'],
						$date_pos['date_clicked']
					)
					, false, '', 3 );
	}
	print_table_footer(4, '', '', 0);
	
	//forumdisplay
	print_table_start();
	print_table_header("Forum display terms statistic", 4, false, '', 'center');
	print_cells_row( $titles, 1, '', 3 );
	$q = "
		SELECT
			*
		FROM
			$terms_data sd
		LEFT JOIN
			$terms st ON sd.stid=st.stid
		WHERE
			sd.page_type='forumdisplay'
		ORDER BY
			sd.page_id DESC,
			sd.founded DESC
		";
	$index_terms = $db->query_read( $q );
	$f_count = null;
	while ($index_term = $db->fetch_array($index_terms)){
		//$print_terms[] = $index_term;
		if( $f_count != $index_term['page_id'] ){
			print_description_row('Forum with id: '.$index_term['page_id'], 0, 4, '', 'left');
			$f_count = $index_term['page_id'];
		}
		$q = "
			SELECT
				position, date_clicked
			FROM
				".$terms_stats."
			WHERE
				page_type = '".$index_term['page_type']."'
				AND
				page_id = ".$index_term['page_id']."
				AND
				stid = ".$index_term['stid']."
			ORDER BY
				date_clicked DESC
			LIMIT 1
			";
		$date_temp = $db->query_read( $q );
		$date_pos = $db->fetch_array( $date_temp );
		print_cells_row(
					array(
						$index_term['term_value'],
						$index_term['founded'],
						$date_pos['position']==0?'-':$date_pos['position'],
						$date_pos['date_clicked']
					)
					, false, '', 3 );
	}
	print_table_footer(4, '', '', 0);

	//showthread
	print_table_start();
	print_table_header("Show thread terms statistic", 4, false, '', 'center');
	print_cells_row( $titles, 1, '', 3 );
	$q = "
		SELECT
			*
		FROM
			$terms_data sd
		LEFT JOIN
			$terms st ON sd.stid=st.stid
		WHERE
			sd.page_type='showthread'
		ORDER BY
			sd.page_id DESC,
			sd.founded DESC
		";
	$index_terms = $db->query_read( $q );
	$f_count = null;
	while ($index_term = $db->fetch_array($index_terms)){
		//$print_terms[] = $index_term;
		if( $f_count != $index_term['page_id'] ){
			print_description_row('Thread with id: '.$index_term['page_id'], 0, 4, '', 'left');
			$f_count = $index_term['page_id'];
		}
		//select position and date
		$q = "
			SELECT
				position, date_clicked
			FROM
				".$terms_stats."
			WHERE
				page_type = '".$index_term['page_type']."'
				AND
				page_id = ".$index_term['page_id']."
				AND
				stid = ".$index_term['stid']."
			ORDER BY
				date_clicked DESC
			LIMIT 1
			";
		$date_temp = $db->query_read( $q );
		$date_pos = $db->fetch_array( $date_temp );
		print_cells_row(
					array(
						$index_term['term_value'],
						$index_term['founded'],
						$date_pos['position']==0?'-':$date_pos['position'],
						$date_pos['date_clicked']
					)
					, false, '', 3 );
	}
	print_table_footer(4, '', '', 0);
	
	//end of statistic
	//print_table_footer(4, '', '', 0);
}
print_cp_footer();
//print_description_row('lalla', 0, 4, '', 'center');
//print_cp_message('This is a control panel message box.');

?>